package lac.contextnet.sddl_longrunningtest.adapters;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.jude.easyrecyclerview.adapter.BaseViewHolder;

import lac.contextnet.sddl_longrunningtest.R;


public class SmartphoneViewHolder extends BaseViewHolder<SmartphoneModel> {

    private SmartphoneAdapter activityAdapter;
    ImageView pieceBox;
    TextView title, description;
    Context context;


    public SmartphoneViewHolder(ViewGroup parent, final SmartphoneAdapter adapter, final Context context) {
        super(parent, R.layout.list_item);

        pieceBox = $(R.id.pieceBox);
        description = $(R.id.description);
        title = $(R.id.title);
        activityAdapter = adapter;
        this.context = context;

    }


    @Override
    public void setData(final SmartphoneModel phone){
        pieceBox.setColorFilter(phone.getColor());
        title.setText(phone.getTitle());
        description.setText(phone.getLat() + ", " + phone.getLng());
    }


}
